#ifndef _ROUTINES_CPP
#define _ROUTINES_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <Stdio.H>
#include <Stdlib.H>

#include "NSWFL.H"
#include "Entry.H"
#include "Init.H"
#include "WinService.H"
#include "Console.H"
#include "Routines.H"

#include "../CSockSrvr/CSockSrvr.H"

#include "../Dialogs/MainDlg.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

char gsSessionLogDir[MAX_PATH];
char gsImportTempDir[MAX_PATH];
char gsAuthKey[MAX_AUTH_LENGTH];
char gsAuthString[MAX_AUTH_LENGTH];

char gsSQLDataFiles[MAX_PATH]; // Relative to server.
char gsDefaultDBO[255];

char gsSQLCustDriver[255];
char gsSQLCustPassword[255];
char gsSQLCustServer[255];
char gsSQLCustUserID[255];

char gsSQLIndexDatabase[255];
char gsSQLIndexDriver[255];
char gsSQLIndexPassword[255];
char gsSQLIndexServer[255];
char gsSQLIndexUserID[255];

int giKeyGenLength = 0;
int giListenPort = 0;
int giMaxClients = 0;
int giRawHashLen = 0;
int giHashTimeoutMS = 0;
int giPingTimeoutMS = 0;

int giTotalConnects = 0;
int giWarningCount = 0;
int giErrorCount = 0;

bool gbShowSplashScreen = false;
bool gbStartAutomatically = false;

FILE *gfhSessionLog = NULL;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool GetRegistryValues(void)
{
	DWORD iSizeofString = 0;

	iSizeofString = sizeof(gsDefaultDBO);
	memset(gsDefaultDBO, 0, iSizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "DefaultDBO", gsDefaultDBO, iSizeofString))
        return false;

	iSizeofString = sizeof(gsSQLDataFiles);
	memset(gsSQLDataFiles, 0, iSizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "SQLDataFiles", gsSQLDataFiles, iSizeofString))
        return false;

	iSizeofString = sizeof(gsSessionLogDir);
	memset(gsSessionLogDir, 0, iSizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "SessionLogDir", gsSessionLogDir, iSizeofString))
        return false;

	iSizeofString = sizeof(gsAuthKey);
	memset(gsAuthKey, 0, iSizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "AuthKey", gsAuthKey, iSizeofString))
        return false;

	iSizeofString = sizeof(gsImportTempDir);
	memset(gsImportTempDir, 0, iSizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "ImportTempDir", gsImportTempDir, iSizeofString))
        return false;

	iSizeofString = sizeof(gsAuthString);
	memset(gsAuthString, 0, iSizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "AuthString", gsAuthString, iSizeofString))
        return false;

	iSizeofString = sizeof(gsSQLCustDriver);
	memset(gsSQLCustDriver, 0, iSizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "SQLCustDriver", gsSQLCustDriver, iSizeofString))
        return false;

	iSizeofString = sizeof(gsSQLCustPassword);
	memset(gsSQLCustPassword, 0, iSizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "SQLCustPassword", gsSQLCustPassword, iSizeofString))
        return false;

	iSizeofString = sizeof(gsSQLCustServer);
	memset(gsSQLCustServer, 0, iSizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "SQLCustServer", gsSQLCustServer, iSizeofString))
        return false;

	iSizeofString = sizeof(gsSQLCustUserID);
	memset(gsSQLCustUserID, 0, iSizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "SQLCustUserID", gsSQLCustUserID, iSizeofString))
        return false;

	iSizeofString = sizeof(gsSQLIndexDatabase);
	memset(gsSQLIndexDatabase, 0, iSizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "SQLIndexDatabase", gsSQLIndexDatabase, iSizeofString))
        return false;

	iSizeofString = sizeof(gsSQLIndexDriver);
	memset(gsSQLIndexDriver, 0, iSizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "SQLIndexDriver", gsSQLIndexDriver, iSizeofString))
        return false;

	iSizeofString = sizeof(gsSQLIndexPassword);
	memset(gsSQLIndexPassword, 0, iSizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "SQLIndexPassword", gsSQLIndexPassword, iSizeofString))
        return false;

	iSizeofString = sizeof(gsSQLIndexServer);
	memset(gsSQLIndexServer, 0, iSizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "SQLIndexServer", gsSQLIndexServer, iSizeofString))
        return false;

	iSizeofString = sizeof(gsSQLIndexUserID);
	memset(gsSQLIndexUserID, 0, iSizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "SQLIndexUserID", gsSQLIndexUserID, iSizeofString))
        return false;

	if(!Get_DWORDRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "PingTimeoutMS", (DWORD &)giPingTimeoutMS))
        return false;

	if(!Get_DWORDRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "RawHashLen", (DWORD &)giRawHashLen))
        return false;

	if(!Get_DWORDRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "HashTimeoutMS", (DWORD &)giHashTimeoutMS))
        return false;

	if(!Get_DWORDRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "ListenPort", (DWORD &)giListenPort))
        return false;

	if(!Get_DWORDRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "MaxClients", (DWORD &)giMaxClients))
        return false;

	if(!Get_DWORDRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "KeyGenLength", (DWORD &)giKeyGenLength))
        return false;

	if(!Get_DWORDRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "DropBadPackets", (DWORD &)gbDropBadPackets))
        return false;

	if(!Get_DWORDRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "PacketMode", (DWORD &)gbPacketMode))
        return false;

	if(!Get_DWORDRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "NextClientID", (DWORD &)giNextClientID))
        return false;

	if(!Get_DWORDRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "ShowSplashScreen", (DWORD &)gbShowSplashScreen))
        return false;

	if(!Get_DWORDRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "StartAutomatically", (DWORD &)gbStartAutomatically))
        return false;

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool SaveRegistryValues(void)
{
	Set_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "DefaultDBO", gsDefaultDBO);
	Set_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "SQLDataFiles", gsSQLDataFiles);
	Set_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "SessionLogDir", gsSessionLogDir);
    Set_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "AuthKey", gsAuthKey);
    Set_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "ImportTempDir", gsImportTempDir);
    Set_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "AuthString", gsAuthString);
    Set_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "SQLCustDriver", gsSQLCustDriver);
    Set_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "SQLCustPassword", gsSQLCustPassword);
    Set_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "SQLCustServer", gsSQLCustServer);
    Set_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "SQLCustUserID", gsSQLCustUserID);
    Set_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "SQLIndexDatabase", gsSQLIndexDatabase);
    Set_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "SQLIndexDriver", gsSQLIndexDriver);
    Set_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "SQLIndexPassword", gsSQLIndexPassword);
    Set_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "SQLIndexServer", gsSQLIndexServer);
    Set_StringRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "SQLIndexUserID", gsSQLIndexUserID);

	giNextClientID = gServer.GetNextClientID();

	Set_DWORDRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "PingTimeoutMS", (DWORD)giPingTimeoutMS);
	Set_DWORDRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "RawHashLen", (DWORD)giRawHashLen);
	Set_DWORDRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "HashTimeoutMS", (DWORD)giHashTimeoutMS);
	Set_DWORDRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "ListenPort", (DWORD)giListenPort);
	Set_DWORDRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "MaxClients", (DWORD)giMaxClients);
	Set_DWORDRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "KeyGenLength", (DWORD)giKeyGenLength);
	Set_DWORDRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "DropBadPackets", (DWORD)gbDropBadPackets);
	Set_DWORDRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "PacketMode", (DWORD)gbPacketMode);
	Set_DWORDRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "NextClientID", (DWORD)giNextClientID);
	Set_DWORDRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "ShowSplashScreen", (DWORD)gbShowSplashScreen);
	Set_DWORDRegistryValue(HKEY_LOCAL_MACHINE, gsRegistryKey, "StartAutomatically", (DWORD)gbStartAutomatically);

	return true;
}	

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool OpenLogFile(void)
{
    char sFullPath[MAX_PATH];

    SYSTEMTIME ST;

    GetLocalTime(&ST);

    char DateTemp[64 + 1];

    GetDateFormat(LOCALE_USER_DEFAULT, NULL, &ST, "MM-dd-yy", DateTemp,64);

    sprintf(sFullPath, "%s\\%s.txt", gsSessionLogDir, DateTemp);

    if( (gfhSessionLog = fopen(sFullPath, "ab")) == NULL)
        return false;

    return true;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool CloseLogFile(void)
{
	if(gfhSessionLog)
	{
		fclose(gfhSessionLog);
		return true;
	}
	else return false;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void WriteSysLog(char *sMessage)
{
    SYSTEMTIME ST;
    GetLocalTime(&ST);

    char lsDate[64];
    char lsTime[64];
	char lsTemp[MAX_STATUS_TEXT + (64 * 2) + 1];

    GetDateFormat(LOCALE_USER_DEFAULT, DATE_SHORTDATE, &ST, NULL, lsDate, 64);
    GetTimeFormat(LOCALE_USER_DEFAULT, 0, &ST, NULL, lsTime, 64);

	sprintf(lsTemp, "(%s %s) [*] %s", lsDate, lsTime, sMessage);
	fprintf(gfhSessionLog, "%s\r\n", lsTemp);
    InsertListBoxItem(MDI.LogList_hWnd, lsTemp, -1);
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void WriteLog(int iClientId, char *sMessage)
{
    SYSTEMTIME ST;
    GetLocalTime(&ST);

    char lsDate[64];
    char lsTime[64];
	char lsTemp[MAX_STATUS_TEXT + (64 * 2) + 1];

    GetDateFormat(LOCALE_USER_DEFAULT, DATE_SHORTDATE, &ST, NULL, lsDate, 64);
    GetTimeFormat(LOCALE_USER_DEFAULT, 0, &ST, NULL, lsTime, 64);

	sprintf(lsTemp, "(%s %s) [%d] %s", lsDate, lsTime, iClientId, sMessage);
	fprintf(gfhSessionLog, "%s\r\n", lsTemp);
    InsertListBoxItem(MDI.LogList_hWnd, lsTemp, -1);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool WaitOnApplicationToExit(void)
{
    gbKillApplication = true; // Tell application to exit

    if(gbIsMainDialogOpen)
    {
        EndDialog(MainDialog_hWnd, 0);
    }

	if(gbConsoleOpen)
	{
		CloseConsole();
	}

    while(gbApplicationRunning) // Wait on application to exit
    {
        Sleep(1);
    }

    return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int CmdCmp(const char *sBuf, const char *sCmd)
{
	int iCmdLen = strlen(sCmd);
	if( strncmp(sBuf, sCmd, iCmdLen) == 0)
		return iCmdLen;
	else return 0;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int AppendDataToCmd(const char *sCmd, char *sData, int iDataSz, char *sOutBuf)
{
	int iRPos = 0;
	int iRWos = strlen(sCmd);

	strcpy(sOutBuf, sCmd);

	while(iRPos < iDataSz)
		sOutBuf[iRWos++] = sData[iRPos++];

	return iRWos;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int BreakCmdFromData(const char *sBuf, int iCmdLen, int iBufSz, char *sOutBuf)
{
	int WPos = 0;
	int RPos = iCmdLen;

	while(RPos < iBufSz)
		sOutBuf[WPos++] = sBuf[RPos++];

	sOutBuf[WPos] = '\0';

	return WPos;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void CreateFolderStructure(char *sFullPath)
{
    char Directory[MAX_PATH];

    int NameLength = strlen(sFullPath);
    int Position = 0;

    while(Position < NameLength)
    {
        if(sFullPath[Position] == '\\' || sFullPath[Position] == '/')
        {
            Directory[Position] = '\0';
            CreateDirectory(Directory, NULL);
        }

        Directory[Position] = sFullPath[Position];

        Position++;
    }
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#endif
